<?php
require_once 'init.php';
ensure_logged_in();
$user = current_user($pdo);

$errors = [];
$success = null;

if($_SERVER['REQUEST_METHOD'] === 'POST'){
    // update name or password
    if(isset($_POST['update_profile'])){
        $name = trim($_POST['name'] ?? '');
        if($name === '') $errors[] = "Name required";
        if(empty($errors)){
            $stmt = $pdo->prepare("UPDATE users SET name = ? WHERE id = ?");
            $stmt->execute([$name, $user['id']]);
            $success = "Profile updated.";
            $user = current_user($pdo);
        }
    } elseif(isset($_POST['change_password'])){
        $old = $_POST['old_password'] ?? '';
        $new = $_POST['new_password'] ?? '';
        $new2 = $_POST['new_password2'] ?? '';
        if($new === '' || strlen($new) < 6) $errors[] = "New password >= 6 chars";
        if($new !== $new2) $errors[] = "New passwords do not match";
        // verify old
        $stmt = $pdo->prepare("SELECT password FROM users WHERE id = ?");
        $stmt->execute([$user['id']]);
        $row = $stmt->fetch();
        if(!$row || !password_verify($old, $row['password'])) $errors[] = "Old password incorrect";

        if(empty($errors)){
            $hp = password_hash($new, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("UPDATE users SET password = ? WHERE id = ?");
            $stmt->execute([$hp, $user['id']]);
            $success = "Password changed.";
        }
    }
}

include 'header.php';
?>

<h2>Profile</h2>

<?php if($errors): ?>
  <div class="alert alert-danger"><ul><?php foreach($errors as $e) echo "<li>".htmlspecialchars($e)."</li>";?></ul></div>
<?php endif; ?>
<?php if($success): ?>
  <div class="alert alert-success"><?=htmlspecialchars($success)?></div>
<?php endif; ?>

<div class="card mb-4">
  <div class="card-body">
    <h5 class="card-title"><?=htmlspecialchars($user['name'])?></h5>
    <p class="card-text"><strong>Email:</strong> <?=htmlspecialchars($user['email'])?></p>
    <p class="card-text"><small>Member since <?=htmlspecialchars($user['created_at'])?></small></p>
  </div>
</div>

<form method="post" class="mb-4">
  <h5>Update profile</h5>
  <div class="mb-3">
    <label class="form-label">Name</label>
    <input name="name" class="form-control" value="<?=htmlspecialchars($user['name'])?>">
  </div>
  <button name="update_profile" class="btn btn-primary">Save</button>
</form>

<form method="post">
  <h5>Change password</h5>
  <div class="mb-3">
    <label class="form-label">Old password</label>
    <input name="old_password" type="password" class="form-control">
  </div>
  <div class="mb-3">
    <label class="form-label">New password</label>
    <input name="new_password" type="password" class="form-control">
  </div>
  <div class="mb-3">
    <label class="form-label">Confirm new password</label>
    <input name="new_password2" type="password" class="form-control">
  </div>
  <button name="change_password" class="btn btn-warning">Change password</button>
</form>

<?php include 'footer.php'; ?>
