<?php
require_once 'init.php';

$errors = [];
if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $password2 = $_POST['password2'] ?? '';

    if($name === '') $errors[] = "Name required";
    if(!filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = "Valid email required";
    if(strlen($password) < 6) $errors[] = "Password must be >= 6 chars";
    if($password !== $password2) $errors[] = "Passwords do not match";

    if(empty($errors)){
        // check email unique
        $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
        $stmt->execute([$email]);
        if($stmt->fetch()){
            $errors[] = "Email already registered";
        } else {
            $hash = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("INSERT INTO users (name,email,password) VALUES (?,?,?)");
            $stmt->execute([$name,$email,$hash]);
            $_SESSION['user_id'] = $pdo->lastInsertId();
            session_regenerate_id(true);
            header('Location: dashboard.php');
            exit;
        }
    }
}
include 'header.php';
?>
<h2>Sign up</h2>

<?php if($errors): ?>
  <div class="alert alert-danger">
    <ul><?php foreach($errors as $e) echo "<li>".htmlspecialchars($e)."</li>"; ?></ul>
  </div>
<?php endif; ?>

<form method="post" class="mb-4">
  <div class="mb-3">
    <label class="form-label">Name</label>
    <input name="name" class="form-control" value="<?=htmlspecialchars($_POST['name'] ?? '')?>">
  </div>
  <div class="mb-3">
    <label class="form-label">Email</label>
    <input name="email" class="form-control" value="<?=htmlspecialchars($_POST['email'] ?? '')?>">
  </div>
  <div class="mb-3">
    <label class="form-label">Password</label>
    <input name="password" type="password" class="form-control">
  </div>
  <div class="mb-3">
    <label class="form-label">Confirm Password</label>
    <input name="password2" type="password" class="form-control">
  </div>
  <button class="btn btn-primary">Register</button>
</form>

<?php include 'footer.php'; ?>
