<?php
require_once 'init.php';
ensure_logged_in();
$user = current_user($pdo);

$id = (int)($_GET['id'] ?? 0);
$stmt = $pdo->prepare("SELECT * FROM projects WHERE id = ? AND user_id = ?");
$stmt->execute([$id, $user['id']]);
$project = $stmt->fetch();
if(!$project){
    header('Location: dashboard.php');
    exit;
}

$errors = [];
if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $title = trim($_POST['title'] ?? '');
    $description = trim($_POST['description'] ?? '');
    $status = $_POST['status'] ?? 'planning';
    $start_date = $_POST['start_date'] ?: null;
    $end_date = $_POST['end_date'] ?: null;

    if($title === '') $errors[] = "Title required";

    if(empty($errors)){
        $stmt = $pdo->prepare("UPDATE projects SET title=?, description=?, status=?, start_date=?, end_date=? WHERE id=? AND user_id=?");
        $stmt->execute([$title,$description,$status,$start_date,$end_date,$id,$user['id']]);
        header('Location: dashboard.php');
        exit;
    }
}

include 'header.php';
?>

<h2>Edit project</h2>

<?php if($errors): ?>
  <div class="alert alert-danger"><ul><?php foreach($errors as $e) echo "<li>".htmlspecialchars($e)."</li>";?></ul></div>
<?php endif; ?>

<form method="post">
  <div class="mb-3">
    <label class="form-label">Title</label>
    <input name="title" class="form-control" value="<?=htmlspecialchars($_POST['title'] ?? $project['title'])?>">
  </div>
  <div class="mb-3">
    <label class="form-label">Description</label>
    <textarea name="description" class="form-control"><?=htmlspecialchars($_POST['description'] ?? $project['description'])?></textarea>
  </div>
  <div class="mb-3">
    <label class="form-label">Status</label>
    <select name="status" class="form-select">
      <option value="planning" <?= ($project['status']=='planning') ? 'selected' : '' ?>>Planning</option>
      <option value="in_progress" <?= ($project['status']=='in_progress') ? 'selected' : '' ?>>In Progress</option>
      <option value="done" <?= ($project['status']=='done') ? 'selected' : '' ?>>Done</option>
    </select>
  </div>
  <div class="row">
    <div class="col">
      <label class="form-label">Start date</label>
      <input name="start_date" type="date" class="form-control" value="<?=htmlspecialchars($_POST['start_date'] ?? $project['start_date'])?>">
    </div>
    <div class="col">
      <label class="form-label">End date</label>
      <input name="end_date" type="date" class="form-control" value="<?=htmlspecialchars($_POST['end_date'] ?? $project['end_date'])?>">
    </div>
  </div>
  <div class="mt-3">
    <button class="btn btn-primary">Save</button>
    <a class="btn btn-secondary" href="dashboard.php">Cancel</a>
  </div>
</form>

<?php include 'footer.php'; ?>
