<?php
require_once 'init.php';
ensure_logged_in();
$user = current_user($pdo);
$errors = [];
if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $title = trim($_POST['title'] ?? '');
    $description = trim($_POST['description'] ?? '');
    $status = $_POST['status'] ?? 'planning';
    $start_date = $_POST['start_date'] ?: null;
    $end_date = $_POST['end_date'] ?: null;

    if($title === '') $errors[] = "Title required";

    if(empty($errors)){
        $stmt = $pdo->prepare("INSERT INTO projects (user_id,title,description,status,start_date,end_date) VALUES (?,?,?,?,?,?)");
        $stmt->execute([$user['id'],$title,$description,$status,$start_date,$end_date]);
        header('Location: dashboard.php');
        exit;
    }
}

include 'header.php';
?>

<h2>Create project</h2>

<?php if($errors): ?>
  <div class="alert alert-danger"><ul><?php foreach($errors as $e) echo "<li>".htmlspecialchars($e)."</li>";?></ul></div>
<?php endif; ?>

<form method="post">
  <div class="mb-3">
    <label class="form-label">Title</label>
    <input name="title" class="form-control" value="<?=htmlspecialchars($_POST['title'] ?? '')?>">
  </div>
  <div class="mb-3">
    <label class="form-label">Description</label>
    <textarea name="description" class="form-control"><?=htmlspecialchars($_POST['description'] ?? '')?></textarea>
  </div>
  <div class="mb-3">
    <label class="form-label">Status</label>
    <select name="status" class="form-select">
      <option value="planning">Planning</option>
      <option value="in_progress">In Progress</option>
      <option value="done">Done</option>
    </select>
  </div>
  <div class="row">
    <div class="col">
      <label class="form-label">Start date</label>
      <input name="start_date" type="date" class="form-control" value="<?=htmlspecialchars($_POST['start_date'] ?? '')?>">
    </div>
    <div class="col">
      <label class="form-label">End date</label>
      <input name="end_date" type="date" class="form-control" value="<?=htmlspecialchars($_POST['end_date'] ?? '')?>">
    </div>
  </div>
  <div class="mt-3">
    <button class="btn btn-primary">Create</button>
    <a class="btn btn-secondary" href="dashboard.php">Cancel</a>
  </div>
</form>

<?php include 'footer.php'; ?>
