<?php
require_once 'init.php';
$errors = [];
if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    if(!filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = "Valid email required";
    if($password === '') $errors[] = "Password required";

    if(empty($errors)){
        $stmt = $pdo->prepare("SELECT id,password FROM users WHERE email = ?");
        $stmt->execute([$email]);
        $user = $stmt->fetch();
        if($user && password_verify($password, $user['password'])){
            $_SESSION['user_id'] = $user['id'];
            session_regenerate_id(true);
            header('Location: dashboard.php');
            exit;
        } else {
            $errors[] = "Invalid credentials";
        }
    }
}

include 'header.php';
?>
<h2>Login</h2>

<?php if($errors): ?>
  <div class="alert alert-danger">
    <ul><?php foreach($errors as $e) echo "<li>".htmlspecialchars($e)."</li>"; ?></ul>
  </div>
<?php endif; ?>

<form method="post" class="mb-4">
  <div class="mb-3">
    <label class="form-label">Email</label>
    <input name="email" class="form-control" value="<?=htmlspecialchars($_POST['email'] ?? '')?>">
  </div>
  <div class="mb-3">
    <label class="form-label">Password</label>
    <input name="password" type="password" class="form-control">
  </div>
  <button class="btn btn-primary">Login</button>
</form>

<?php include 'footer.php'; ?>
