<?php
// init.php - include on pages that need session and DB
session_start();
require_once __DIR__ . '/config.php';

function is_logged_in(){
    return !empty($_SESSION['user_id']);
}

function current_user($pdo){
    if(!is_logged_in()) return null;
    $stmt = $pdo->prepare("SELECT id, name, email, created_at FROM users WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    return $stmt->fetch();
}

function ensure_logged_in(){
    if(!is_logged_in()){
        header('Location: login.php');
        exit;
    }
}
