<?php
require_once 'init.php';
ensure_logged_in();
$user = current_user($pdo);

// search
$q = trim($_GET['q'] ?? '');

// pagination
$page = max(1, (int)($_GET['page'] ?? 1));
$perPage = 6;
$offset = ($page - 1) * $perPage;

// count total (for this user)
$countSql = "SELECT COUNT(*) FROM projects WHERE user_id = ?";
$params = [$user['id']];

if($q !== ''){
    $countSql = "SELECT COUNT(*) FROM projects WHERE user_id = ? AND (title LIKE ? OR description LIKE ?)";
    $params = [$user['id'], "%$q%", "%$q%"];
}
$total = (int)$pdo->prepare($countSql)->execute($params) ? 0 : 0;
// we need to properly fetch count:
$stmtCount = $pdo->prepare($countSql);
$stmtCount->execute($params);
$total = (int)$stmtCount->fetchColumn();

// fetch paginated
$sql = "SELECT * FROM projects WHERE user_id = ?";
$params = [$user['id']];

if($q !== ''){
    $sql = "SELECT * FROM projects WHERE user_id = ? AND (title LIKE ? OR description LIKE ?)";
    $params = [$user['id'], "%$q%", "%$q%"];
}

$sql .= " ORDER BY created_at DESC LIMIT ? OFFSET ?";
$params[] = $perPage;
$params[] = $offset;

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$projects = $stmt->fetchAll();

$pages = (int)ceil($total / $perPage);

include 'header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-3">
  <h2>My Projects</h2>
  <a class="btn btn-success" href="project_create.php">+ New Project</a>
</div>

<form class="mb-3" method="get">
  <div class="input-group">
    <input name="q" class="form-control" placeholder="Search projects..." value="<?=htmlspecialchars($q)?>">
    <button class="btn btn-outline-secondary">Search</button>
  </div>
</form>

<?php if(!$projects): ?>
  <div class="alert alert-info">No projects found.</div>
<?php else: ?>
  <div class="list-group mb-3">
    <?php foreach($projects as $p): ?>
      <div class="list-group-item">
        <div class="d-flex justify-content-between">
          <div>
            <h5><?=htmlspecialchars($p['title'])?></h5>
            <p class="mb-1"><?=nl2br(htmlspecialchars(substr($p['description'],0,250)))?></p>
            <small>Status: <?=htmlspecialchars($p['status'])?> | Created: <?=htmlspecialchars($p['created_at'])?></small>
          </div>
          <div class="text-end">
            <a href="project_edit.php?id=<?= $p['id'] ?>" class="btn btn-sm btn-primary mb-1">Edit</a>
            <a href="project_delete.php?id=<?= $p['id'] ?>" onclick="return confirm('Delete?')" class="btn btn-sm btn-danger">Delete</a>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>

  <!-- pagination -->
  <nav>
    <ul class="pagination">
      <?php for($i=1;$i<=$pages;$i++): ?>
        <li class="page-item <?= $i===$page ? 'active' : '' ?>">
          <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page'=>$i])) ?>"><?= $i ?></a>
        </li>
      <?php endfor; ?>
    </ul>
  </nav>
<?php endif; ?>

<?php include 'footer.php'; ?>
